<?php
/*#################################################################################
	AdLogger
	- An open-source tracking tool for preventing click fraud

	Copyright 2006 by Trevor Fitzgerald
	http://www.adlogger.org

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	If you find this script useful, please share it with others!

	Thank you!
*/#################################################################################

// Start a session and include the configuration files.
session_start();
require ("../config_database.php");
require ("../config_settings.php");
require ("../config_admin.php");

/*
This value is set by the login_verify.php page. If the user wasn't logged in,
it redirects them to the login page but remembers where they tried to access.
After they login, it'll send them directly to their intended location.
*/
$ref_redirect = mysql_real_escape_string($_GET['ref']);

/*
If the person asked to be remembered,
go ahead and skip the login page and
redirect them right away to the main page
*/
if ($_COOKIE["$admin_cookie"] == $login_hash) {
	$_SESSION["$admin_cookie"] = $login_hash;
	if (empty($ref_redirect)) {
		header("Location: ./");
	} else {
		header("Location: $ref_redirect");
	}
	exit();
}

/*
If the person is already logged in, they
don't have any reason to be at the login page.
Redirect them to the index page.
*/
if ($_SESSION["$admin_cookie"] == $login_hash) {
	header("Location: ./");
	exit();
}

// Call the functions to start the timer, html output, and database connection verfication
require ("./functions.php");
	$start_time = micro_time(0);
	bodyHeader('login', $version_num);
	bodyNavigation('login');
	check_db_connection($adlogger_db_connect, $adlogger_db_select);
?>

<div id="side-bar">
	<div>
		<p class="sideBarTitle">Login</p>
	</div>
</div>

<div id="main-copy">

	<h1 id="introduction">AdLogger Login</h1>
	<p>Enter your username and password.</p>

	<?php
		/*
		The installation directory should have been deleted right after the installation.
		If it's still there, give the user a message telling him to delete the directory.
		*/
		if (is_dir('../install')) {
			echo "<span class=\"loginMessage\">The installation directory must be deleted before you can login.</span><br /><br />";
			/*
			It's very important to delete the install directory, 
			so we're not going to let the person login until they do.
			*/
			$discontinue_login = true;
		} elseif (!check_permissions('../config_admin.php') || !check_permissions('../config_settings.php') || !check_permissions('../config_database.php')) {
			/*
			If any of the configuration files (config_admin.php, config_database.php, or config_settings.php)
			are still writable, display a message telling him to change those permissions.
			*/
			echo "<span class=\"loginMessage\">Please CHMOD the configuration files back to 644.</span><br /><br />";
		}

		// If there are any other messages to display (like from the password reset or login error), show them.
		if (isset($_SESSION['login_message'])) {
			echo "<span class=\"loginMessage\">" . $_SESSION['login_message'] . "</span><br /><br />";
			unset($_SESSION['login_message']);
		}
	?>
	<form name="loginform" method="post" action="./logincheck.php">
	
		<fieldset>
			<legend>Login</legend>
			
			<label for="username">Username:</label>
			<input name="username" id="loginbox" tabindex="1" />
			<br />
			<label for="password">Password:</label>
			<input name="password" type="password" tabindex="2" />
			<br />
			<label for="remember">Remember me?:</label>
			<input name="remember" type="checkbox" id="remember" value="checkbox" tabindex="3" />
			
			<input type="hidden" name="ref_redirect" value="<?php echo $ref_redirect; ?>" />
			<br />
			
			<label for="submit">&nbsp;</label>
			<input type="submit" value="Login" id="submit" tabindex="4" <?php if ($discontinue_login) echo "disabled=\"disabled\" "; ?>/>
			
			<br />
			<br />
			<label for="pwreset">&nbsp;</label>
			<a href="./pwreset.php">Forget your password?</a>
			<br />
		</fieldset>

	</form>
</div>

<?php
// Output the closing HTML for the footer.
bodyFooter('login', $start_time);
?>